% ex8_72pf.m 
% particle filter; deterministic resampling
% subsection 8.7.2
clear;

d=0.5;
d2=sqrt(d);
n=4; p=2; l=2;
Q=[1000  0        %covariance of system noise
    0  100]; 
R=[1000  0        %covariance of observation noise
    0  0.001];
A=[1 d 0 0;
   0 1 0 0;
   0 0 1 d;
   0 0 0 1];
B=[d*d2/2 0;
    d2    0;
    0  d*d2/2;
    0  d2];
T=50;    % Time for simulation
N=T/d;   % Number of data  
%
M=200; % number of particles
%randn('state',0);
tic
for kkk=1:10
% for kkk=1:100    % # of Monte Calro runs
%------generation of data---------------------------------
x0=[3000 100 1000 -50]'; % Initial state
x=zeros(n,N+1);
y=zeros(p,N+1);
w=sqrt(Q)*randn(l,N+1);   %system noise
v=sqrt(R)*randn(p,N+1);   %observation noise
%
x(:,1)=x0;
for k=1:N
x(:,k+1)=A*x(:,k) + B*w(:,k);
y(1,k)=sqrt(x(1,k)*x(1,k)+x(3,k)*x(3,k))+v(1,k);
y(2,k)=atan2(x(3,k),x(1,k))+v(2,k);
end
y(1,N+1)=sqrt(x(1,N+1)*x(1,N+1)+x(3,N+1)*x(3,N+1))+v(1,N+1);
y(2,N+1)=atan2(x(3,N+1),x(1,N+1))+v(2,N+1);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialize Particle filter
xef=zeros(n,N+1);
rr=R(1,1)*R(2,2);
xt0=x0;
P0=[1000  0   0   0;             % initial value of covariance
     0  100   0   0;             %
     0   0  1000  0;             %
     0   0   0  100];            %
ypart=zeros(p,1);
xpart=zeros(n,M);
xpartef=zeros(n,M);
nu=zeros(p,M);
% Initialize the particle filter
%tic
for i=1:M
    xpart(:,i)=x0+sqrt(P0)*randn(n,1);
end
for k=1:N+1 % k for time index
for i=1:M   % i for particle index
ypart(1)=sqrt(xpart(1,i)*xpart(1,i)+xpart(3,i)*xpart(3,i));
ypart(2)=atan2(xpart(3,i),xpart(1,i));
nu(:,i)=y(:,k)-ypart;
tau= nu(:,i)'*inv(R)*nu(:,i)/2;
alpha(i) = exp(-tau)/(2*pi*sqrt(rr));
end
% Normalization of the weights 
mm=sum(alpha);
alpha=alpha./mm;
% Resampling
c=0.5;
    for j=1:M
        xi = (j-c)/M; 
        xisum = 0;
        for i=1:M
            xisum = xisum + alpha(i);
            if xisum >= xi
                xpartef(:,j) = xpart(:,i);
                break;
            end
        end
    end
% filtered estimate
xef(:,k)=mean(xpartef,2);
% predicted estimates
for i=1:M
xpart(:,i)=A*xpartef(:,i)+B*sqrt(Q)*randn(2,1);
end
end % of index k
% Time_PF=toc
% for figure
for j=1:N+1
RMSE(j)=sqrt((x(1,j)-xef(1,j))^2+(x(3,j)-xef(3,j))^2);
end
rmse_PF=mean(RMSE);
err(kkk)=rmse_PF;
end % of kkk
error_PF=mean(err)
Time_PF=toc

%
J=0:N;
J=J*d;
figure(1)
plot(x(1,:),x(3,:),'r-',xef(1,:),xef(3,:),'b^','LineWidth',1.5)
grid
xlabel('x_t')
ylabel('y_t')
legend('True trajectory','Estimation by PF')
title('Fig. 8.7a: True trajectory and estimate by PF')

figure(2)
plot(J,RMSE,'mo-','LineWidth',1.5)
xlabel('Time(sec)')
title('Root mean square errors of states')
ylabel('RMSE')
grid
